/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.WasmFunctionRepository;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.generate.common.methods.BaseWasmGenerationContext;
import org.teavm.backend.wasm.generators.WasmMethodGenerator;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmTag;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.Import;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.classes.VirtualTableProvider;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.Characteristics;
import org.teavm.parsing.resource.ResourceProvider;

public class WasmGenerationContext
implements BaseWasmGenerationContext {
    private ClassReaderSource classSource;
    private ClassHierarchy classHierarchy;
    private ResourceProvider resources;
    public final WasmModule module;
    private final WasmFunctionTypes functionTypes;
    private final WasmFunctionRepository functions;
    private Diagnostics diagnostics;
    private VirtualTableProvider vtableProvider;
    private TagRegistry tagRegistry;
    private WasmStringPool stringPool;
    public final NameProvider names;
    public final Characteristics characteristics;
    private Map<MethodReference, ImportedMethod> importedMethods = new HashMap<MethodReference, ImportedMethod>();
    private List<WasmIntrinsic> intrinsics = new ArrayList<WasmIntrinsic>();
    private List<WasmMethodGenerator> generators = new ArrayList<WasmMethodGenerator>();
    private Map<MethodReference, IntrinsicHolder> intrinsicCache = new HashMap<MethodReference, IntrinsicHolder>();
    private Map<MethodReference, GeneratorHolder> generatorCache = new HashMap<MethodReference, GeneratorHolder>();
    private WasmTag exceptionTag;
    private final List<CallSiteDescriptor> callSites = new ArrayList<CallSiteDescriptor>();

    public WasmGenerationContext(ClassReaderSource classSource, ClassHierarchy classHierarchy, ResourceProvider resources, WasmModule module, WasmFunctionTypes functionTypes, WasmFunctionRepository functions, Diagnostics diagnostics, VirtualTableProvider vtableProvider, TagRegistry tagRegistry, WasmStringPool stringPool, NameProvider names, Characteristics characteristics, WasmTag exceptionTag) {
        this.classSource = classSource;
        this.classHierarchy = classHierarchy;
        this.resources = resources;
        this.module = module;
        this.functionTypes = functionTypes;
        this.functions = functions;
        this.diagnostics = diagnostics;
        this.vtableProvider = vtableProvider;
        this.tagRegistry = tagRegistry;
        this.stringPool = stringPool;
        this.names = names;
        this.characteristics = characteristics;
        this.exceptionTag = exceptionTag;
    }

    @Override
    public WasmFunctionRepository functions() {
        return this.functions;
    }

    @Override
    public WasmFunctionTypes functionTypes() {
        return this.functionTypes;
    }

    @Override
    public ClassReaderSource classes() {
        return this.classSource;
    }

    @Override
    public ResourceProvider resources() {
        return this.resources;
    }

    public ClassHierarchy getClassHierarchy() {
        return this.classHierarchy;
    }

    public List<CallSiteDescriptor> callSites() {
        return this.callSites;
    }

    public void addIntrinsic(WasmIntrinsic intrinsic) {
        this.intrinsics.add(intrinsic);
    }

    public void addGenerator(WasmMethodGenerator generator) {
        this.generators.add(generator);
    }

    public WasmIntrinsic getIntrinsic(MethodReference method) {
        return this.intrinsicCache.computeIfAbsent((MethodReference)method, (Function<MethodReference, IntrinsicHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getIntrinsic$1(org.teavm.model.MethodReference ), (Lorg/teavm/model/MethodReference;)Lorg/teavm/backend/wasm/generate/WasmGenerationContext$IntrinsicHolder;)((WasmGenerationContext)this)).value;
    }

    public WasmMethodGenerator getGenerator(MethodReference method) {
        return this.generatorCache.computeIfAbsent((MethodReference)method, (Function<MethodReference, GeneratorHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getGenerator$3(org.teavm.model.MethodReference ), (Lorg/teavm/model/MethodReference;)Lorg/teavm/backend/wasm/generate/WasmGenerationContext$GeneratorHolder;)((WasmGenerationContext)this)).value;
    }

    public ImportedMethod getImportedMethod(MethodReference reference) {
        return this.importedMethods.computeIfAbsent(reference, ref -> {
            String module;
            ClassReader cls = this.classSource.get(ref.getClassName());
            if (cls == null) {
                return null;
            }
            MethodReader method = cls.getMethod(ref.getDescriptor());
            if (method == null) {
                return null;
            }
            AnnotationReader annotation = method.getAnnotations().get(Import.class.getName());
            if (annotation == null) {
                return null;
            }
            String name = annotation.getValue("name").getString();
            AnnotationValue moduleValue = annotation.getValue("module");
            String string = module = moduleValue != null ? moduleValue.getString() : null;
            if (module != null && module.isEmpty()) {
                module = null;
            }
            return new ImportedMethod(name, module);
        });
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public ValueType getFieldType(FieldReference fieldReference) {
        ClassReader cls = this.classSource.get(fieldReference.getClassName());
        FieldReader field = cls.getField(fieldReference.getFieldName());
        return field.getType();
    }

    public VirtualTableProvider getVirtualTableProvider() {
        return this.vtableProvider;
    }

    public TagRegistry getTagRegistry() {
        return this.tagRegistry;
    }

    public WasmStringPool getStringPool() {
        return this.stringPool;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public WasmTag getExceptionTag() {
        return this.exceptionTag;
    }

    private /* synthetic */ GeneratorHolder lambda$getGenerator$3(MethodReference key) {
        return new GeneratorHolder(this.generators.stream().filter(generator -> generator.isApplicable(key)).findFirst().orElse(null));
    }

    private /* synthetic */ IntrinsicHolder lambda$getIntrinsic$1(MethodReference key) {
        return new IntrinsicHolder(this.intrinsics.stream().filter(intrinsic -> intrinsic.isApplicable(key)).findFirst().orElse(null));
    }

    static class IntrinsicHolder {
        WasmIntrinsic value;

        IntrinsicHolder(WasmIntrinsic value) {
            this.value = value;
        }
    }

    static class GeneratorHolder {
        WasmMethodGenerator value;

        GeneratorHolder(WasmMethodGenerator value) {
            this.value = value;
        }
    }

    public static class ImportedMethod {
        public final String name;
        public final String module;

        ImportedMethod(String name, String module) {
            this.name = name;
            this.module = module;
        }
    }
}

