/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug.parser;

import java.util.ArrayList;
import org.teavm.backend.wasm.debug.info.ClassInfo;
import org.teavm.backend.wasm.debug.info.MethodInfo;
import org.teavm.backend.wasm.debug.parser.DebugClassParser;
import org.teavm.backend.wasm.debug.parser.DebugSectionParser;
import org.teavm.backend.wasm.debug.parser.DebugStringParser;

public class DebugMethodParser
extends DebugSectionParser {
    private DebugStringParser strings;
    private DebugClassParser classes;
    private MethodInfoImpl[] methods;

    public DebugMethodParser(DebugStringParser strings, DebugClassParser classes) {
        super("teavm_mtd", new DebugSectionParser[0]);
        this.strings = strings;
        this.classes = classes;
    }

    public MethodInfo getMethod(int ptr) {
        return this.methods[ptr];
    }

    @Override
    protected void doParse() {
        ArrayList<MethodInfoImpl> methods = new ArrayList<MethodInfoImpl>();
        while (this.ptr < this.data.length) {
            ClassInfo cls = this.classes.getClass(this.readLEB());
            String name = this.strings.getString(this.readLEB());
            methods.add(new MethodInfoImpl(cls, name));
        }
        this.methods = methods.toArray(new MethodInfoImpl[0]);
    }

    private static class MethodInfoImpl
    extends MethodInfo {
        private ClassInfo cls;
        private String name;

        MethodInfoImpl(ClassInfo cls, String name) {
            this.cls = cls;
            this.name = name;
        }

        @Override
        public ClassInfo cls() {
            return this.cls;
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

