/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.apachecommons.cli.help;

import java.util.Arrays;

final class Util {
    private static final int NOT_FOUND = -1;

    static <T extends CharSequence> T defaultValue(T str, T defaultValue) {
        return Util.isEmpty(str) ? defaultValue : str;
    }

    static int indexOfNonWhitespace(CharSequence text, int startPos) {
        int idx;
        if (Util.isEmpty(text)) {
            return -1;
        }
        for (idx = startPos; idx < text.length() && Util.isWhitespace(text.charAt(idx)); ++idx) {
        }
        return idx < text.length() ? idx : -1;
    }

    static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    static boolean isWhitespace(char c) {
        return Character.isWhitespace(c) || '\u000e' == c;
    }

    static String ltrim(String s) {
        int pos = Util.indexOfNonWhitespace(s, 0);
        return pos == -1 ? "" : s.substring(pos);
    }

    static String repeat(int len, char fillChar) {
        char[] padding = new char[len];
        Arrays.fill(padding, fillChar);
        return new String(padding);
    }

    static String repeatSpace(int len) {
        return Util.repeat(len, ' ');
    }

    static String rtrim(String s) {
        int pos;
        if (Util.isEmpty(s)) {
            return s;
        }
        for (pos = s.length(); pos > 0 && Util.isWhitespace(s.charAt(pos - 1)); --pos) {
        }
        return s.substring(0, pos);
    }

    private Util() {
    }
}

